<title>Calliope Youngblood; circa 2025-05.</title>
<main>
# Calliope Youngblood

<div>
<div style="float: left">
1. [calliope@operand.online](mailto:calliope@operand.online)
1. 202-880-2779
</div>

<div style="float: right; text-align: right;">
1. resume on [calliope.operand.online](https://calliope.operand.online)
1. essays and code on [operand.online](https://operand.online)
</div>
</div>

- - -

## [lead] Operand Company

> 2023-01 > ongoing

### [research] resilience engineering

- produce a modern program-and-deploy experience using secure and reproducible modules.
- encode and deploy a [company domain] page as an experiment in replacing WordPress.
- replace early-career approaches and codebases, using a much more capable selection of languages and base dependencies.
- deploy and manage numerous online program labs, running dozens of application subdomains.
- deploy on-premise email, passcode management, wiki-based guides, graphic co-design spaces, source-code relays, public discussion boards, audience metrics, and program logging apps.
- rebuild core dependencies using [Nix], [Nushell], [Elixir], and [Hyprland].

[company domain]: https://operand.online
[Nix]: https://nixos.org
[Nushell]: https://nushell.sh
[Elixir]: https://elixir-lang.org
[Hyprland]: https://hyprland.org

![a diagram displaying Operand Co's original lab, running email and many open-source programs.](../lab.png)

### [commission] Pain Away of Philadelphia

> 2023-09 > 2023-12

- redesigned a [scheduling procedure] able to supersede SquareSpace's experience.
- enabled group bookings, and doubled the annual business income as recorded in SquareSpace.
- designed graphics displaying revenue per day, and comparable on an annual basis.

[scheduling procedure]: https://book.painawayofphilly.com

<div class="pb"></div>

- - -

## Martial Arts

> Ongoing

- Childhood Aikido lessons in Tokyo, Japan.
- Tae Kwon Do through middle and high school.
- Aikido: 2022 through 2024 - 3 years at Capitol Hill Aikikai
- Wing Chun, Jow Ga: 3 months, Autumn 2024.

- - -

## [board] HacDC

> 2022-10 > 2024-02

### Hyperdemocracy

- co-designed the [curriculum][hyperdemocracy], to share modern machine learning approaches.
- prepared a language model capable of examining US Congressional legislation.
- ran an online API-scraping program to source legislation in bulk from [api.congress.gov].

[hyperdemocracy]: https://huggingface.co/hyperdemocracy
[api.congress.gov]: https://api.congress.gov

### Secretary, 2023

- Radically reshaped our shared space, to demolish an unusable bathroom, arrange a server-rack room, and add an overhead cable bridge.
- Pioneered group's social media presence on LinkedIn and YouTube.
- Co-managed a speaker series, including camera live-streaming using a DSLR-to-USB recording procedure.
- Led migration of group wiki from legacy WikiMedia instance to modern [Wiki.JS].
- Led collaboration with nonprofit neighbors in our building, to learn screen-printing skills in exchange for mechanical help.

[Wiki.JS]: https://js.wiki

- - -

## US House of Representatives, Clerk's Office

> 2021-10 > 2023-02

- Collaborated with the House Digital Service to plan Legidex, an official employee index.
- Prototyped an organization address book, based on scans of ActiveDirectory records.
- Prototyped a replacement legislation composition engine, to enable peer collaboration while honoring legacy and future legislative schemas.
- Co-produced, and coded, modules in LIMS - the legislative information management system.
- Co-produced, and coded, eHopper - the legislation submission engine.
- Deployed many on-premise applications, to examine the reception of open-source code in the clerk's office.
- Managed Red Hat Enterprise Linux machines, and learned the pains of misaligned `libc` versions, in dynamically-linked libraries.
- Managed upgrades and common issues across [XMetaL], the legislation composition engine.
- Managed many thousands of keyboard-bound macros in XMetaL, made in JavaScript, Perl, and VBScript.

![a diagram made during proposal of a house address book program to HDS](../hds.scaled.png)

[XMetaL]: https://xmetal.com

<div class="pb"></div>

- - -

## [lead] Assemble Company

> 2017-01 > 2023-12

### [research] state legislation comparative analysis

- prepared an online copy procedure (scraper) for legal codes on [justia.com].
- Reproduced the [RINGS visualization] to quickly compare structures of state legal codes.

[RINGS visualization]: https://www.researchgate.net/publication/30508486_RINGS_A_Technique_for_Visualizing_Large_Hierarchies

![A rendered graphic analogy of how Michigan's legal code is organized, as one among a broad inter-state comparison.](../rings.png)

### [commission] U of Washington, [Clinical Informatics Research Group][CIRG]

- Produced [a mobile web application][cirg-app] designed to measure and ensure medication adherence, in a Tuberculosis research group.
- Bilingual applicación included a calendar displaying adherence, camera upload, disease FAQ, and care coordinator communicación.
- A companion coordinator application helped research clinicians engage their patient groups.

[cirg-app]: https://github.com/uwcirg/tb-mobile-app

### [commission] Nimbus Lounge, Resource & Room Sales Panel

- Composed a resource-tracking application to enable customers to book rooms and tables.
- Management panel displayed business metrics and applied discounts across menu.
- Ran as a production point-of-sale for many years, and had been included in the sale of the business.

### [commission] Accupac, Industrial Manufacturing

- Led the procurement of a business intelligence platform, [Sisense], after appraising six options.
- Prototyped applications and command-line programs based around core business reporting.
- Prototyped laboratory experiment management applications, including barcode references.

### [research] pipeline-based programming using docker images and serialized message-passing.

- Prototyped a cloud container pipeline-programming platform, in Docker's early years.
- Deployed a browser extension to enable per-page scraping of resources, as an ingress process.

[Sisense]: https://www.sisense.com/
[justia.com]: https://justia.com
[CIRG]: https://cirg.uw.edu

<div class="pb"></div>

- - -

## Code for America

> 2016-01 > 2016-12

### [commission] Prison Occupancy Dashboard

- combined municipal prison records to design a compelling dashboard of cell-and-bed occupancy across buildings.
- in response to density, examined occupants with minor offenses, who may be recommended for early release.
- plainly displayed some challenges of overpopulation based on the pace of ingress & egress.

### [commission] Seattle Police Department; RideAlong Labs

- led adoption of Docker as a moldable deployment option, on a department-managed offline, isolated network.
- [education] led a skills-building curriculum, based on Ruby on Rails and modern command-line programs.
- complied to FBI [CJIS] guidance necessary to run an application in a criminal justice -focused secure deployment space.
- Produced information architecture diagrams, port security appraisals, and application-specific page-access and page-edit auditing procedures.
- complied to [HIPAA] requirements regarding the healthcare concerns and residency scenarios of specific Seattleites who commonly rely upon police.
- Collaborated in the 2016 Data-Driven Justice Symposium, in the presidential compound's Eisenhower Executive Office Building.
- In emeritus, co-founded [RideAlong Labs] as a consequence of research and collaboration alongside police.

[CJIS]: https://le.fbi.gov/cjis-division/the-cjis-advisory-process
[HIPAA]: https://www.hhs.gov/hipaa/for-professionals/privacy/laws-regulations/index.html
[RideAlong Labs]: https://web.archive.org/web/20190125161351/https://getridealong.com/

![A Seattle Police challenge coin; Crisis Intervention Team](../spd.jpg)

<div class="pb"></div>

- - -

## Thoughtbot; an app design & production agency

> 2014-11 > 2015-12

### [education]

- led colleagues in the adoption of React, replacing many JS libraries in sporadic use.
- led discussions on VimScript, an editor configuration language in broad use across company.
- led colleagues in the adoption of python, through the Flask and Django web frameworks.

### [open source] [Administrate][admin]

- produced a dynamic, all-purpose admin dashboards in Ruby on Rails.
- dedicated each Friday ("investment day") to leading design and production.
- coordinated user interviews and focus groups to decide on scope and reach.
- managed a global release, including blog post, podcast appearance, hacker news announcement.
- channeled many eager responses through forum and issue management on GitHub.

[admin]: https://administrate-demo.herokuapp.com

![A sample of the guidebook for the Administrate Dashboard package.](../administrate.png)

### [product] [Hound](https://www.houndci.com/)

- helped manage a program to nudge coding habits, based on automated comments on GitHub code changes.

### [commission] [Automattic](https://automattic.com/)

- prepared individualized displays of consumer's OBD car sensor readings.
- applied personas based on driving norms.

### [commission] [Lending Tree](https://www.lendingtree.com/)

- produced a simple onboarding experience helping consumers acquire home loans by describing their financial scenario.

### [commission] Glassbreakers

- [education] led a skills-building curriculum, based on the nascent React web-app paradigm.

### [commission] [Autodesk](https://www.autodesk.com/) scheduling & project management

- produced a Gantt chart to help Autodesk manage product scheduling across company.
- Based application on backbone.js, a minimal library, to ensure ease of upgrade in a chaotic pre-React landscape.

### [commission] [Donors Choose](https://www.donorschoose.org/)

- Designed changes to help crowd-funding teachers reach a broader audience through focused campaigns.

<div class="pb"></div>

- - -

## [education] EuRuCamp 2014, demo service-oriented architecture

> 2014-06

- an on-stage [coding demo] of a logging aggregation program based on [RabbitMQ].

[coding demo]: http://media.eurucamp.org/eurucamp/2014/grayson_wright
[RabbitMQ]: https://www.rabbitmq.com/

- - -

## [internship] Microsoft

> 2012-05 > 2012-08

- managed legacy printer drivers, during a large-scale OS upgrade process to Windows 8, and launch of the Surface tablet.

- - -

## [board] Association of Computing Machinery college chapter, VP.

> 2011-01 > 2014-05

- produced and led hackathons and coding challenges.
- organized a semimonthly schedule of speakers from local industry and academia.
- managed a student mailing list on college machines, using the early linux postman programme.
- enrolled in hackathons and videogame jams led by similar student groups in nearby colleges, including [Spartasoft] and [Mhacks].

[Spartasoft]: https://gamedev.msu.edu/spartasoft/
[Mhacks]: https://mhacks-2024.mhacks.org/

- - -

## [education] Michigan State University

> 2010-09 > 2014-05

- Computer Science bachelor's degree, including a partial graduate courseload in cybersecurity & algorithms.
- a rigorously-paced mathematics progression focusing in combined calculus and linear algebras.
- ancillary courses in electrical engineering, behavioral psychology, Chinese language.
- [research] genetic algorithms & digital evolution, in the multi-university [BEACON] program.
- [research] Expanded the [AVIDA] simulation program, wherein organisms' actions are led by genetic mutation & recombination, to enable predator-prey dynamics.
- [research] [crowdfunding dynamics] using a home-made app to fund student media productions. 
- [research] agent-based modeling of macro-economic population dynamics.

[BEACON]: https://web.archive.org/web/20241120063119/https://beacon-center.org/
[crowdfunding dynamics]: https://rickwash.com/research.html#socio-technical-design-of-crowdfunding-websites
[AVIDA]: https://avida-ed.msu.edu/

- - -

## [education] Zhejiang University

- One semester study abroad, focused on Mandarin Chinese.
- Conversational speaker in many scenarios.

- - -
</main>

<style>
@font-face {
  font-family: "ancizar";
  src: url("../AncizarSans-VariableFont_wght.ttf") format("truetype");
}

* { font-family: "ancizar"; }

html { width: 100vw; height: 100vh; background-color: lightgrey; }
body { color: #666; font-weight: 700; font-size: 16px; position: relative; }
main { max-width: 60rem; margin-left: auto; margin-right: auto; padding: 2rem; }

h1, a { color: purple; }
h2 { color: brown; margin-bottom: 0; }
h3 { margin: 0; color: #444; }

p, li { line-height: 1.2rem; }

blockquote { text-align: right; margin-top: -1.5rem; margin-bottom: 1rem; margin-right: 0; }
blockquote > p {
  background-color: skyblue;
  display: inline-block;
  padding: 0.25rem 1rem;
  margin: 0;
}

img { max-height: 40rem; max-width: 80vw; margin: 0; margin-bottom: 1rem; }

hr { border-color: brown; border-width: 6px; margin-top: 1rem; clear: both; }
hr:first-of-type, hr:last-of-type { border-color: skyblue; border-width: 15px; }

ol > li { list-style: none; }
ul { margin-top: 0; }

@media print {
  body { font-size: 12px; font-weight: 400; }
  html { background: none; }
  .pb { page-break-after: always; }
  h1, h2, h3, p, ul, hr, main { width: auto; max-width: none; margin-left: 0; margin-right: 0; }
  blockquote > p { padding: 0; }
}
</style>

<script>
[...(document.querySelectorAll("img"))].forEach(node =>
  node.addEventListener("click", () => window.location.href = node.getAttribute("src"))
)
</script>
